IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_EXTRATO]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_CPL_EXTRATO]
GO
GO   

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 202202251030
'Job.................:  
'Nome................: P_EST_PROD_CPL_EXTRATO 
'Objetivo............: Procedure responsavel por gerar extrato do estoque flutuante.
'Tabelas.............: COMP_REST_RS_VLR_MEDIO_POND_MOVEL_UNIT, TMP_P_GERA_MEDIA_PONDERADA_APOIO_REPROCESSAMENTO, COMP_REST_RS_VLR_MEDIO_POND_MOVEL_UNIT_REPROCESSAMENTO, COMP_REST_RS_VLR_MEDIO_POND_MOVEL_UNIT_BACKUP_REPROCESSAMENTO
'Dt Criação..........: 
'Criado por..........: 
'Dt Ult Alteracão....: 25/02/2022
'Alterado por........: Estevan Aquiles Pazzetti

'=======================================================================================
-- Lançar alterações de versão aqui:
Reg #202202251030 - Atualização de tratamento de mensagens retornadas ao cliente, acrescentado ou retirado o cliente olha a quantidade se é negativa ou positiva  - Luiz Carlos dos Santos Lacerda Junior 

*/
/*  
 Extrato do Produto mas  
 conhecido como KARDEX  
  
 EMPRESA: ItecGyn Consultoria
 DATA INICIO: 16/06/2012  
 DATA TERMINO:16/06/2012   
 PROFISSIONAL:  Cristiano Nunes  
*/  
--  P_EST_PROD_CPL_EXTRATO 1 ,2 ,72065,'20180101' ,'20181227' ,'20171231' ,0
--Versao 2765
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_EXTRATO](@CD_EMP	INT,  
											   @CD_FILIAL	INT,  
											   @CD_PROD		INT,  
											   @DT_INI		DATETIME,  
											   @DT_FIM		DATETIME,  
											   @DT_FECHA_EST DATETIME=NULL,  
											   @TP_EST		INT,
											   @IGN_DT_INI_SYS INT = 0) AS
BEGIN  
SET NOCOUNT ON 
CREATE TABLE #RS_MOV (
						CD_DOC				INT,
						TP_MOV				INT,
						DT_MOV				DATETIME,
						CD_MOV				INT, 
						DS_MOV_CPL			VARCHAR(80), 
						DS_MOV				VARCHAR(200),
						CD_PROD				INT, 
						DS_PROD				VARCHAR(200), 
						QT_IT				MONEY, 
						VLR_ENT				MONEY, 
						VLR_CUSTO			MONEY,
						VLR_CUSTO_TOTAL		MONEY, 
						TP_TRANSA			INT, 
						ORD_APRES			INT,
						TP_LANC_FECHA_EST   INT,
						TP_DOC				INT,
						DT_REGISTRO		    DATETIME,
						TIPO_PREFATURA      VARCHAR(100),
						SNGPC_TEM			INT,
						SNGPC_LANCADO		INT,
						NR_DOC				VARCHAR(20),
						SERIE_DOC			VARCHAR(10))

CREATE TABLE #RS_EXTRATO 
		(ORDEM				INT IDENTITY (1, 1),
		CD_DOC				INT, 
		TP_MOV				INT,		 
		DT_MOV				DATETIME, 
		CD_MOV				INT,
		DS_MOV_CPL			VARCHAR(80), 
		DS_MOV				VARCHAR(200),
		CD_PROD				INT, 
		DS_PROD				VARCHAR(200), 
		QT_IT				MONEY,
		VLR_ENT				MONEY, 
		VLR_CUSTO			MONEY,
		VLR_CUSTO_TOTAL		MONEY,
		TP_TRANSA			INT, 
		QT_EST				MONEY,
		TP_LANC_FECHA_EST   INT,				
		TP_DOC				INT,
		DT_REGISTRO			DATETIME,
		TIPO_PREFATURA      VARCHAR(100),
		SNGPC_TEM			INT,
		SNGPC_LANCADO		INT)

DECLARE @TP_CUSTO   MONEY
DECLARE @QT_EST		MONEY  
DECLARE @VLR_CUSTO  MONEY  
DECLARE @DT_INI_SIS DATETIME  
DECLARE @DT_POS_INI DATETIME  
DECLARE @DT_POS_FIM DATETIME  
DECLARE @ORDEM INT
DECLARE @TRANSA INT
DECLARE @QT_MOV  MONEY
DECLARE @DT_MOV DATETIME  
DECLARE @CONTROLE_SNGPC INT
Declare @SqlComando as varchar(1500)


IF @DT_FECHA_EST IS NULL 
BEGIN
	SET @DT_FECHA_EST = @DT_INI -1
END

DECLARE @DS_PROD  VARCHAR(200);

/************************************************************************************************/

SELECT 
	@DS_PROD = LEFT(DS_PROD, 200),
	@CONTROLE_SNGPC=ISNULL(@CONTROLE_SNGPC,0)
FROM 
	EST_PROD
WHERE 
	CD_EMP =   @CD_EMP 
	AND CD_PROD = @CD_PROD;


/************************************************************************************************/
 

/*
	0 - Nao definido
	1 - Nota fiscal de entrada
	2 - Estorno entrada
	3 - Ajuste estoque
	4 - Cupom fiscal
	5 - Nota fiscal de saida
	6 - Pedido de vendas
	7 - Pedido de compras
*/
if @tp_est=1
begin
	SET @VLR_CUSTO =  dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (@CD_EMP,@CD_FILIAL,@CD_PROD,getdate(),20); 
end
else
begin
	SET @VLR_CUSTO =  ISNULL((SELECT 
								VLR_CUSTO_MD	
							  FROM 
								EST_PROD_CPL 
							  WHERE 
								CD_EMP = @CD_EMP 
								AND CD_FILIAL = @CD_FILIAL 
								AND CD_PROD	  = @CD_PROD),0)   
end

IF @IGN_DT_INI_SYS = 0
	BEGIN
		SET @DT_INI_SIS=(SELECT DT_INI_SISTEMA FROM PRC_FILIAL
							WHERE
							@CD_EMP	=1
							AND CD_FILIAL = @CD_FILIAL);
	END
ELSE
	BEGIN
		SET @DT_INI_SIS=@DT_INI 
	END 
	
	
--Se a data de inicio do sistema for maior q o fechamento ou dt ini solicitada
if @DT_INI_SIS >= @DT_FECHA_EST
	set @DT_FECHA_EST=  DBO.F_FINAL_MES (dateadd(day,(datepart(day,@DT_INI_SIS)+1)*-1,@DT_INI_SIS)); 

if @DT_INI_SIS > @DT_INI
	set @DT_INI=@DT_INI_SIS;

INSERT INTO #RS_MOV  
SELECT       
	0 CD_NF,
	0 TP_MOV,
	cast(dateadd(DAY, -1, @DT_INI) AS DATETIME),   
	0 AS CD_MOV,  
	DS_MOV_CPL = 'ESTOQUE INICIAL DE FECHAMENTO',  
	DS_MOV = 'ESTOQUE INICIAL DE FECHAMENTO EM ' + CONVERT(VARCHAR(10),@DT_FECHA_EST,103),   
	EST_FECHA.CD_PROD,   
	@DS_PROD DS_PROD,  
	CASE WHEN @TP_EST= 0 THEN  
		EST_FECHA.QT_EST  
	WHEN @TP_EST=1 THEN  
		ISNULL(EST_FECHA.QT_EST_FLUT,0)  
	WHEN @TP_EST=2 THEN  
		ISNULL(EST_FECHA.QT_EST_EM_TERC,0)  
	WHEN @TP_EST=3 THEN  
		ISNULL(EST_FECHA.QT_EST_DE_TERC,0)  
	END,   
	0,
	CASE WHEN @TP_EST= 1 THEN  
		EST_FECHA.VLR_CUSTO_MD_FLUTUANTE
	ELSE EST_FECHA.VLR_CUSTO_MD END  VLR_CUSTO_MD,  
	0,  
	0,  
	0,
	1, --Indica estoque de fechamento,
	0 AS TP_DOC,
	cast(dateadd(DAY, -1, @DT_INI) AS DATETIME),
	'',
	0,
	0,
	'',
	''
FROM           
	EST_FECHA 
	INNER JOIN EST_PROD_CPL ON   
	EST_FECHA.CD_EMP = EST_PROD_CPL.CD_EMP AND   
	EST_FECHA.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND   
	EST_FECHA.CD_PROD = EST_PROD_CPL.CD_PROD    
WHERE       
	EST_FECHA.CD_EMP = @CD_EMP   
	AND EST_FECHA.CD_FILIAL = @CD_FILIAL   
	AND EST_FECHA.ANO_FECHA = YEAR(@DT_FECHA_EST)  
	AND EST_FECHA.MES_FECHA = MONTH(@DT_FECHA_EST)   
	AND EST_FECHA.CD_PROD = @CD_PROD  

/*
	Se data de inicio do sistema for maior que a data de fechamento 
	nao pega dados reatroativo.
*/	
--IF @DT_FECHA_EST > @DT_INI_SIS 
--BEGIN
--IF DATEDIFF(day, @DT_FECHA_EST, @DT_INI) > 1   	     
--	SET @DT_POS_INI = Dateadd(DAY, 1, @DT_FECHA_EST)  
--	SET @DT_POS_FIM = Dateadd(DAY, -1, @DT_INI)  
--	BEGIN  
--		UPDATE #RS_MOV  
--		SET  
--			CD_MOV = 0,  
--			DS_MOV_CPL = 'POSICAO DO ESTOQUE',  
--			DS_MOV = 'POSICAO DO ESTOQUE ATE O DIA ' + CONVERT(VARCHAR(10), cast(dateadd(DAY, -1, @DT_INI) AS DATETIME),103) ,        
--			QT_IT = QT_IT + ISNULL((SELECT  
--										UFD.QT_IT  
--									FROM  
--										UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, @CD_PROD, @DT_POS_FIM,@TP_EST) UFD ),0), 
--			VLR_CUSTO = @VLR_CUSTO  
--		WHERE   
--			CD_MOV = 0
--	END  
--END
------------------------------------------------------------------------------------  
IF NOT EXISTS (SELECT * FROM #RS_MOV)  
	INSERT INTO #RS_MOV  
	SELECT       
		DISTINCT  
		0 CD_DOC,
		0 TP_MOV, 
		cast(dateadd(DAY, -1, @DT_INI) AS DATETIME),   
		0 ,  
		'ESTOQUE INICIAL',  
		'ESTOQUE INICIAL DE ' + CONVERT(VARCHAR(10),@DT_FECHA_EST,103),   
		EST_PROD_CPL.CD_PROD,   
		@DS_PROD DS_PROD,     
		0,  
		0 VLR_ENT,
		@VLR_CUSTO,
		0,
		0,
		0,
		0,
		0 AS TP_DOC,
		cast(dateadd(DAY, -1, @DT_INI) AS DATETIME),
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM           
		EST_PROD_CPL  
	WHERE       
		EST_PROD_CPL.CD_EMP = @CD_EMP   
		AND EST_PROD_CPL.CD_PROD = @CD_PROD  

IF @TP_EST = 0 --Estoque comercializacao  
Begin  
	--Entrada de mercadoria por compras  
	INSERT INTO #RS_MOV  
		SELECT E.CD_NF,
			   1 TP_MOV,
			   CONVERT(CHAR(10), E.DT_ENT, 120)+'  '+CONVERT(CHAR(8), ISNULL(TRY_CONVERT(DATETIME,E.HR_ENT), ''), 114),
			   CD_MOV = o.CD_MOV_OP,
			   DS_MOV_CPL = o.DS_MOV_OP,
			   DS_OP = DS_MOV_OP+' REF. NOTA FISCAL NR.: '+CONVERT(VARCHAR(10), NR_NF)+'   CD. ORIGEM.: '+CONVERT(VARCHAR(10), CD_FORN)+' CIDADE: '+isnull (CIDADE_EMITENTE,'N INFORMADA')+' - '+isnull (UF_EMITENTE,''),
			   I.CD_PROD,
			   @DS_PROD,
			   I.QT_IT,
			   CONVERT(FLOAT, I.VLR_TOT_IT) / CONVERT(FLOAT,
													  CASE
														  WHEN I.QT_IT = 0
														  THEN 1
														  ELSE I.QT_IT
													  END) AS VLR_IT,
			   @VLR_CUSTO,
			   0,
			   1,
			   0,
			   0,
			   1 AS TP_DOC,
			   CONVERT(CHAR(10), ISNULL(e.DT_HR_CAD, e.DT_ENT), 120)+'  '+CONVERT(CHAR(8), ISNULL(e.DT_HR_CAD, ''), 114),
			   '',
			   0,
			   0,
			   '' NR_DOC,
			   '' SR_DOC
		FROM EST_NF_ENT e
			 JOIN EST_NF_ENT_IT i ON E.CD_EMP = I.CD_EMP
									 AND E.CD_FILIAL = I.CD_FILIAL
									 AND E.CD_NF = I.CD_NF
									 AND E.DT_ENT = I.DT_ENT
			 INNER JOIN DBO.GLB_MOV_OP O ON E.CD_NT_MOV = O.CD_MOV_OP
			 LEFT JOIN PDV_VD_EST_NF_ENT ON E.CD_EMP = PDV_VD_EST_NF_ENT.CD_EMP
											AND E.CD_FILIAL = PDV_VD_EST_NF_ENT.CD_FILIAL
											AND E.CD_NF = PDV_VD_EST_NF_ENT.CD_NF
		WHERE I.CD_EMP = @CD_EMP
			  AND I.CD_FILIAL = @CD_FILIAL
			  AND I.DT_ENT BETWEEN @DT_INI AND @DT_FIM
			  AND I.CD_PROD = @CD_PROD
			  AND O.ATU_EST = 1
			  AND O.TP_ESTQ = 0
			  AND E.STS_NF = 0
			  AND PDV_VD_EST_NF_ENT.CD_EMP IS NULL
		ORDER BY E.CD_NF;

	--Entrada estorno
	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		1 TP_MOV,
		I.DT_ENT,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		1	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC 
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 0  
	order by 
		I.CD_CTR;
  
	 --Ajuste de estoque  
	 INSERT INTO #RS_MOV  
	 SELECT       
		EST_PROD_IMP.CD_IMP AS CD_DOC,
		2 TP_MOV,     
		EST_PROD_IMP.DT_CAD,   
		CD_MOV = CASE WHEN TP_IMP = 0 THEN  
					10000  
				  WHEN TP_IMP = 1 THEN  
					10001  
				  WHEN TP_IMP = 2 THEN  
					10002  
				  ELSE  
					10003  
				  END,  
		DS_MOV_CPL = CASE WHEN TP_IMP = 0 THEN  
							'AJUSTE DE ESTOQUE'  
						WHEN TP_IMP = 1 THEN  
							'FECHAMENTO DE BALANCO'  
						ELSE  
							'SEM CLASSIFICACAO'  
						END,  
		DS_OP = case when awms.CD_AJUSTE_WMS IS NULL THEN 
					CASE WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL  AND  EST_PROD_IMP_DETERIORADO.CD_IMP IS NULL THEN  
						'AJUSTE DE ESTOQUE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU 
					WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP > 0 THEN  
					'TRANSFERENCIA ESTOQUE FLUTUANTE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
					WHEN TP_IMP = 0  AND EST_PROD_IMP_DETERIORADO.CD_IMP > 0 THEN  
					'INFORMACAO DE VENCIDO/DETERIORADOS EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU 
					WHEN TP_IMP = 1 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
					'FECHAMENTO DE BALANCO EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
					WHEN TP_IMP = 2 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
					'DIFERENCA(S) DETECTADA(S) PELO USUARIO: ' + GLB_USU.NM_USU  
					WHEN TP_IMP = 3 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
					'AJUSTE DE FALTA(S) DETECTADA(S) ANTERIORMENTE' 
					WHEN TP_IMP = 4 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
					'BLOQUEIO/DESBLOQUEIO PELO USUARIO: '  + GLB_USU.NM_USU	
					ELSE  
					'SEM CLASSIFICACAO, SOLICITE A CLASSIFICACAO DA MESMA'  
					END
		   ELSE
				EST_PROD_IMP.HIST
		   END,  
		EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PROD_IMP.QT_IMP,
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	 FROM   
		EST_PROD_IMP  
		INNER JOIN GLB_USU ON   
		EST_PROD_IMP.CD_USU = GLB_USU.CD_USU
  
		LEFT OUTER JOIN EST_PROD_IMP_FLUTUANTE ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_IMP_FLUTUANTE.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_FLUTUANTE.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_IMP_FLUTUANTE.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_IMP_FLUTUANTE.CD_PROD  

		LEFT OUTER JOIN EST_PROD_IMP_DETERIORADO ON  
		EST_PROD_IMP.CD_EMP = EST_PROD_IMP_DETERIORADO.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_DETERIORADO.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_IMP_DETERIORADO.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_IMP_DETERIORADO.CD_PROD  

		LEFT OUTER JOIN EST_PROD_IMP_AJUSTE_WMS awms ON
		EST_PROD_IMP.CD_EMP = awms.CD_EMP AND
		EST_PROD_IMP.CD_FILIAL = awms.CD_FILIAL AND
		EST_PROD_IMP.CD_IMP = awms.CD_IMP AND
		EST_PROD_IMP.CD_PROD = awms.CD_PROD

		LEFT OUTER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_EMP AND   
		EST_PROD_IMP.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD
	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP   
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL   
		AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 0  
		AND EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD IS NULL
		AND TP_IMP < 5;  

	--Saida por transferenca requisicao  
	INSERT INTO #RS_MOV  
	SELECT    
		EST_PROD_IMP.CD_IMP,
		2 TP_MOV,        
		EST_PROD_IMP.DT_CAD,   
		CD_MOV = 10004,  
		DS_MOV_CPL = 'REQUISICAO',  
		DS_OP =  'REQUISICAO DE TRANSFERENCIA N   ' + CONVERT(VARCHAR(10),EST_PROD_REQ_TRANSF_LIB.CD_REQ) + '    COD. DESTINO: ' + CONVERT(VARCHAR(10),EST_PROD_REQ_TRANSF_LIB.CD_FILIAL_DEST),  
		EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PROD_IMP.QT_IMP,
		0 VLR_ENT,   
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM   
		EST_PROD_IMP 
		INNER JOIN GLB_USU ON   
		EST_PROD_IMP.CD_USU = GLB_USU.CD_USU   
		INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_EMP AND   
		EST_PROD_IMP.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD   
		INNER JOIN EST_PROD_REQ_TRANSF_LIB ON   
		EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_EMP = EST_PROD_REQ_TRANSF_LIB.CD_EMP AND   
		EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB.CD_FILIAL AND   
		EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_REQ = EST_PROD_REQ_TRANSF_LIB.CD_REQ  
	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP   
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL   
		AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 0  
  
  
 --Entrada por transferenca requisicao  
	INSERT INTO #RS_MOV  
	SELECT   
		EST_PROD_IMP.CD_IMP,
		2 TP_MOV,        
		EST_PROD_IMP.DT_CAD,   
		CD_MOV = 10004,  
		DS_MOV_CPL = 'REQUISICAO',  
		DS_OP =  'REQUISICAO DE TRANSFERENCIA N   ' + CONVERT(VARCHAR(10),EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_REQ) + '    COD. ORIGEM: ' + CONVERT(VARCHAR(10),EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_ORIG),  
		EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PROD_IMP.QT_IMP,   
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM   
		EST_PROD_IMP  
		INNER JOIN GLB_USU ON   
		EST_PROD_IMP.CD_USU = GLB_USU.CD_USU   
		INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP AND   
		EST_PROD_IMP.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_DEST AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD  
	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP   
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL   
		AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 0  
  
		--Devolucao de cupom fiscal  
	INSERT INTO #RS_MOV  
	SELECT    
		EST_PROD_IMP.CD_IMP,
		2 TP_MOV,    
		EST_PROD_IMP.DT_CAD,   
		1006 AS CD_MOV,   
		DS_MOV_CPL= 'DEVOLUCAO DE CUPOM FISCAL',   
		DS_OP = 'DEVOLUCAO CUPOM FISCAL NR.: ' + CONVERT(VARCHAR(10),PDV_VD.NR_ECF) + '   PDV   ' + CONVERT(VARCHAR(4),PDV_VD.CD_CX),    
		PDV_VD_DEV_EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD, 
		EST_PROD_IMP.QT_IMP, 
		0 VLR_ENT, 
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM           
		PDV_VD_DEV_EST_PROD_IMP INNER JOIN EST_PROD_IMP ON   
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD_IMP.CD_EMP AND   
		PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP.CD_FILIAL AND   
		PDV_VD_DEV_EST_PROD_IMP.CD_IMP = EST_PROD_IMP.CD_IMP AND   
		PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD_IMP.CD_PROD   
		INNER JOIN PDV_VD ON   
		PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD AND   
		PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL AND   
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP   
	 
	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP  
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL  
		AND EST_PROD_IMP.DT_CAD BETWEEN  @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 0  
  
 --Saidas por vendas por pdv  
	 
	Set @SqlComando= 'INSERT INTO #RS_MOV SELECT 
		I.CD_VD,
		2 TP_MOV,  
		CONVERT(CHAR(10),v.DT_VD,120) + '' '' + CONVERT(CHAR(8),ISNULL(V.HR_VD,''''),114), 
		CD_MOV = 10003,  
		DS_MOV_CPL = ''VENDAS POR CUPOM FISCAL'',  
		DS_OP = ''VENDAS CUPOM FISCAL NR.: '' , ' + CONVERT(VARCHAR(12), @CD_PROD) + ',   
		''' + @DS_PROD + ''' DS_PROD,   
		SUM(i.QT_IT),
		0 VLR_ENT,  
		' + CONVERT(VARCHAR(10), @VLR_CUSTO) + ',  
		0,  
		2,  
		1,
		0,
		4 AS TP_DOC,
		V.DT_CONSD,
		'''',
		0,
		0,
		v.NR_ECF NR_DOC,
		v.CD_CX SR_DOC
	FROM      
		PDV_VD_IT i 
		INNER JOIN PDV_VD v ON   
		i.CD_EMP=v.CD_EMP AND   
		i.CD_FILIAL=v.CD_FILIAL AND 
		i.CD_VD=v.CD_VD  AND 
		i.DT_VD=v.DT_VD   
	WHERE  I.CD_EMP = ' + CONVERT(VARCHAR(12),@CD_EMP )  + 'AND I.CD_FILIAL = ' + CONVERT(VARCHAR(12),@CD_FILIAL) + ' AND I.DT_VD BETWEEN ''' + CONVERT(VARCHAR(12),@DT_INI,112) 
				+ ''' AND ''' + CONVERT(VARCHAR,@DT_FIM,112) + ''' AND i.CD_PROD = ' + CONVERT(VARCHAR(12),@CD_PROD) +' 
	GROUP BY  
		v.DT_VD,   
		v.NR_ECF,   
		v.CD_CX,   
		i.CD_PROD,    
		I.CD_VD,
		V.DT_CONSD,
		V.HR_VD'

eXEC (@SqlComando)


	/*
	INSERT INTO #RS_MOV  
	SELECT 
		I.CD_VD,
		2 TP_MOV,  
		CONVERT(CHAR(10),v.DT_VD,120) + ' ' + CONVERT(CHAR(5),ISNULL(V.HR_VD,''),114),       
		CD_MOV = 10003,  
		DS_MOV_CPL = 'VENDAS POR CUPOM FISCAL',  
		DS_OP = 'VENDAS CUPOM FISCAL NR.: ' ,--+ CONVERT(VARCHAR(10),v.NR_ECF) + '   PDV   ' + CONVERT(VARCHAR(4),v.CD_CX),   
		@CD_PROD,   
		@DS_PROD DS_PROD,   
		SUM(i.QT_IT),
		0 VLR_ENT,  
		@VLR_CUSTO,  
		0,  
		2,  
		1,
		0,
		4 AS TP_DOC,
		V.DT_CONSD,
		'',
		0,
		0,
		v.NR_ECF NR_DOC,
		v.CD_CX SR_DOC
	FROM      
		PDV_VD_IT i 
		INNER JOIN PDV_VD v ON   
		i.CD_EMP=v.CD_EMP AND   
		i.CD_FILIAL=v.CD_FILIAL AND 
		i.CD_VD=v.CD_VD  AND 
		i.DT_VD=v.DT_VD  

		INNER JOIN EST_PROD ON   
		i.CD_EMP = EST_PROD.CD_EMP AND   
		i.CD_PROD = EST_PROD.CD_PROD   
		INNER JOIN EST_PROD_UN_MED ON   
		EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND   
		EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND   
		EST_PROD.CD_UN_VD = EST_PROD_UN_MED.CD_CTR_UN  
	WHERE     
			I.CD_EMP = @CD_EMP  
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM  
		AND i.CD_PROD = @CD_PROD  
	GROUP BY  
		v.DT_VD,   
		v.NR_ECF,   
		v.CD_CX,   
		i.CD_PROD,   
		EST_PROD.DS_PROD,
		I.CD_VD,
		V.DT_CONSD,
		V.HR_VD'
	*/	
	
	UPDATE #RS_MOV
	SET
		DS_MOV = 'VENDAS CUPOM FISCAL NR.: ' + NR_DOC + '   PDV   ' + SERIE_DOC
	WHERE
		CD_MOV = 10003 
		AND	DS_MOV_CPL = 'VENDAS POR CUPOM FISCAL'

	--Cancelamento de cupom fiscal  
	INSERT INTO #RS_MOV  
	SELECT  
		I.CD_VD,
		2 TP_MOV, 
		CONVERT(CHAR(10),v.DT_VD,120) + ' ' + CONVERT(CHAR(8),ISNULL(V.HR_VD,''),114),       
		CD_MOV = 10004,  
		DS_MOV_CPL = 'CANCELAMENTO VENDAS',  
		DS_OP = CASE WHEN v.ST_VD=1 THEN
					'CANCELAMENTO VENDAS CUPOM FISCAL NR.: ' + CONVERT(VARCHAR(10),v.NR_ECF) + '   PDV   ' + CONVERT(VARCHAR(4),v.CD_CX)

				ELSE
					'ITEM DO CUPOM FISCAL  CANCELADO NR.: ' + CONVERT(VARCHAR(10),v.NR_ECF) + '   PDV   ' + CONVERT(VARCHAR(4),v.CD_CX)   
				END, 
		@CD_PROD,   
		@DS_PROD DS_PROD,   
		SUM(i.QT_IT),  
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0,
		4 AS TP_DOC,
		V.DT_CONSD,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM      
		PDV_VD_IT i INNER JOIN PDV_VD v ON   
		i.CD_EMP=v.CD_EMP AND   
		i.CD_FILIAL=v.CD_FILIAL AND 
		i.CD_VD=v.CD_VD  AND 
		i.DT_VD=v.DT_VD  
	WHERE     
		v.CD_EMP = @CD_EMP  
		AND v.CD_FILIAL = @CD_FILIAL  
		AND v.DT_VD BETWEEN @DT_INI AND @DT_FIM  
		AND i.CD_PROD = @CD_PROD  
		and (v.ST_VD=1 OR I.ST_IT=2) 
	GROUP BY  
		v.DT_VD,   
		v.NR_ECF,   
		v.CD_CX,   
		i.CD_PROD,    
		I.CD_VD,
		V.DT_CONSD,
		v.ST_VD,
		I.ST_IT,
		V.HR_VD
  
	 --Vendas por nota fiscal  
	INSERT INTO #RS_MOV  
	SELECT   
		S.CD_NF,
		2 TP_MOV,     
		CONVERT(CHAR(10),S.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,ISNULL(S.HR_EMI_NF,'')),114),   
		CD_MOV	   = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) + ' CIDADE: ' + S.CIDADE_DESTINATARIO + ' - ' + S.UF_DESTINATARIO,  
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		2,  
		2,
		0,
		5 AS TP_DOC,
		S.DT_HR_CAD,
		'',
		0,
		0,
		'' NR_DOC,
		'' SR_DOC
	FROM      
		EST_NF_SAI s		
		INNER JOIN GLB_MOV_OP O ON s.CD_NT_MOV = O.CD_MOV_OP 
		INNER JOIN EST_NF_SAI_IT I ON
		s.CD_EMP	= I.CD_EMP AND
		s.CD_FILIAL = I.CD_FILIAL AND
		s.CD_NF		= I.CD_NF AND
		s.DT_EMI_NF	= I.DT_EMI_NF 	
	WHERE     
		I.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.CD_PROD = @CD_PROD  
		AND O.BX_EST = 1  
		AND O.TP_ESTQ = 0   
		AND NOT EXISTS (SELECT   
							CD_NF   
						FROM   
							PDV_VD_EST_NF_SAI  
						WHERE  
							S.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND  
							S.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND  
							S.CD_NF = PDV_VD_EST_NF_SAI.CD_NF AND  
							S.CD_EMP = @CD_EMP  
							AND S.CD_FILIAL = @CD_FILIAL)  
	ORDER BY
		S.CD_NF
  
	--Vendas por nota fiscal canceladas
	INSERT INTO #RS_MOV  
	SELECT   
		s.CD_NF,
		2 TP_MOV,     
		CONVERT(CHAR(10),S.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,ISNULL(S.HR_EMI_NF,'')),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP =  LEFT('CANCELAMENTO  ' + CASE WHEN 
				 C.CANCEL_FORA_PRAZO =1 THEN ' FORA PRAZO' ELSE '' END   + DS_MOV_OP +' REF. NOTA FISCAL NR.: ' 
						+ CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) + ' CIDADE: ' + S.CIDADE_DESTINATARIO + ' - ' + S.UF_DESTINATARIO +  ' USUARIO.: ' + GLB_USU.NM_USU, 200),  
		
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO VLR_CUSTO,  
		0 VLR_CUSTO_TOTAL,  
		1 TP_TRANSA,  
		3 ORD_APRES,
		0 TP_LANC_FECHA_EST, 
		5 AS TP_DOC,
		S.DT_HR_CAD DT_REGISTRO,
		'' TIPO_PREFATURA,
		0 SNGPC_TEM,
		0 SNGPC_LANCADO,
		'' NR_DOC,
		'' SR_DOC 
	FROM      
		EST_NF_SAI s
		INNER JOIN EST_NF_SAI_CANCEL C ON
		s.CD_EMP	= C.CD_EMP AND
		s.CD_FILIAL = C.CD_FILIAL AND
		s.CD_NF		= C.CD_NF   
		INNER JOIN GLB_MOV_OP O ON s.CD_NT_MOV = O.CD_MOV_OP 
		INNER JOIN EST_NF_SAI_IT I ON
		s.CD_EMP	= I.CD_EMP AND
		s.CD_FILIAL = I.CD_FILIAL AND
		s.CD_NF		= I.CD_NF AND
		s.DT_EMI_NF	= I.DT_EMI_NF 
		INNER JOIN GLB_USU ON
			C.CD_USU = GLB_USU.CD_USU
	WHERE     
			s.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND s.CD_EMP	= @CD_EMP   
		AND s.CD_FILIAL = @CD_FILIAL  
		AND i.CD_PROD	= @CD_PROD  
		AND o.BX_EST	= 1  
		AND o.TP_ESTQ	= 0   
		AND NOT EXISTS (SELECT   
							CD_NF   
						FROM   
							PDV_VD_EST_NF_SAI  
						WHERE  
							s.CD_EMP	= PDV_VD_EST_NF_SAI.CD_EMP AND  
							s.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND  
							s.CD_NF		= PDV_VD_EST_NF_SAI.CD_NF AND  
							s.CD_EMP	= @CD_EMP  
							AND s.CD_FILIAL = @CD_FILIAL)  
	ORDER BY
		s.CD_NF;

/**********************************************************************************************************************************************/

	INSERT INTO #RS_MOV  
	SELECT   
		s.CD_NF,
		2 TP_MOV,     
		CONVERT(CHAR(10),S.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,ISNULL(S.HR_EMI_NF,'')),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP =  LEFT('INUTILIZACAO  ' + DS_MOV_OP +' REF. NOTA FISCAL NR.: ' 
						+ CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) 
						+ ' CIDADE: ' + S.CIDADE_DESTINATARIO + ' - ' + S.UF_DESTINATARIO +  ' USUARIO.: ' + GLB_USU.NM_USU, 200),  
		
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO VLR_CUSTO,  
		0 VLR_CUSTO_TOTAL,  
		1 TP_TRANSA,  
		3 ORD_APRES,
		0 TP_LANC_FECHA_EST, 
		5 AS TP_DOC,
		S.DT_HR_CAD DT_REGISTRO,
		'' TIPO_PREFATURA,
		0 SNGPC_TEM,
		0 SNGPC_LANCADO,
		'' NR_DOC,
		'' SR_DOC 
	FROM      
		EST_NF_SAI s
		INNER JOIN EST_NF_SAI_EST_NF_NFE_INU C ON
		s.CD_EMP	= C.CD_EMP AND
		s.CD_FILIAL = C.CD_FILIAL AND
		s.CD_NF		= C.CD_NF   

		INNER JOIN EST_NF_NFE_INU U ON
		C.CD_INU		= U.CD_INU  
		
		LEFT JOIN EST_NF_SAI_CANCEL CA ON
		s.CD_EMP	= CA.CD_EMP AND
		s.CD_FILIAL = CA.CD_FILIAL AND
		s.CD_NF		= CA.CD_NF  

		INNER JOIN GLB_MOV_OP O ON s.CD_NT_MOV = O.CD_MOV_OP 
		INNER JOIN EST_NF_SAI_IT I ON
		s.CD_EMP	= I.CD_EMP AND
		s.CD_FILIAL = I.CD_FILIAL AND
		s.CD_NF		= I.CD_NF AND
		s.DT_EMI_NF	= I.DT_EMI_NF 
		INNER JOIN GLB_USU ON
			U.CD_USU = GLB_USU.CD_USU
	WHERE     
			s.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND s.CD_EMP	= @CD_EMP   
		AND s.CD_FILIAL = @CD_FILIAL  
		AND i.CD_PROD	= @CD_PROD  
		AND CA.CD_EMP IS NULL
		AND o.BX_EST	= 1  
		AND o.TP_ESTQ	= 0   
		AND NOT EXISTS (SELECT   
							CD_NF   
						FROM   
							PDV_VD_EST_NF_SAI  
						WHERE  
							s.CD_EMP	= PDV_VD_EST_NF_SAI.CD_EMP AND  
							s.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND  
							s.CD_NF		= PDV_VD_EST_NF_SAI.CD_NF AND  
							s.CD_EMP	= @CD_EMP  
							AND s.CD_FILIAL = @CD_FILIAL)  
	ORDER BY
		s.CD_NF;

/**********************************************************************************************************************************************/
		  
 --Orcamento de vendas  
	INSERT INTO #RS_MOV  
	SELECT       
		EST_PED_VD.CD_PED,
		2 TP_MOV, 
		EST_PED_VD_ORC.DT_CAD,   
		CD_MOV = 10004,  
		DS_MOV_CPL = 'ORCAMENTO DE VENDAS',  
		DS_OP = 'ORCAMENTO DE VENDAS N.: ' + CONVERT(VARCHAR(10),EST_PED_VD.CD_PED) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),EST_PED_VD.CD_CLI),  
		EST_PED_VD_IT.CD_PROD,   
		@DS_PROD DS_PROD,    
		EST_PED_VD_IT.QT_IT,
		0 VLR_ENT,   
		@VLR_CUSTO,  
		0,  
		2,  
		2,
		0,
		6 AS TP_DOC,
		EST_PED_VD.DT_TRANSACAO,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM           
		EST_PED_VD INNER JOIN EST_PED_VD_IT ON 
		EST_PED_VD.CD_EMP = EST_PED_VD_IT.CD_EMP AND   
		EST_PED_VD.CD_FILIAL = EST_PED_VD_IT.CD_FILIAL AND   
		EST_PED_VD.CD_PED = EST_PED_VD_IT.CD_PED 
 
		INNER JOIN EST_PED_VD_ORC ON 
		EST_PED_VD_ORC.CD_EMP = EST_PED_VD.CD_EMP AND   
		EST_PED_VD_ORC.CD_FILIAL = EST_PED_VD.CD_FILIAL AND   
		EST_PED_VD_ORC.CD_PED = EST_PED_VD.CD_PED 
	WHERE  
	    EST_PED_VD_ORC.CD_EMP = @CD_EMP  
		AND EST_PED_VD_ORC.CD_FILIAL = @CD_FILIAL  
		AND EST_PED_VD_IT.CD_PROD = @CD_PROD  
		AND EST_PED_VD_ORC.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
  
 --Orcamento de compras  
	INSERT INTO #RS_MOV  
	SELECT 
		EST_PED_CP.CD_PED,
		2 TP_MOV,       
		EST_PED_CP_ORC.DT_CAD,   
		CD_MOV = 10005,  
		DS_MOV_CPL = 'ORCAMENTO DE COMPRAS',  
		DS_OP = 'ORCAMENTO DE COMPRAS N.: ' + CONVERT(VARCHAR(10),EST_PED_CP.CD_PED) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),EST_PED_CP.CD_FORN),  
		EST_PED_CP_IT.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PED_CP_IT.QT_IT,
		0 VLR_ENT,  
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0,
		7 AS TP_DOC,
		EST_PED_CP.DT_HR_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM           
		EST_PED_CP
		INNER JOIN EST_PED_CP_IT ON   
		EST_PED_CP.CD_EMP = EST_PED_CP_IT.CD_EMP AND   
		EST_PED_CP.CD_FILIAL = EST_PED_CP_IT.CD_FILIAL AND   
		EST_PED_CP.CD_PED = EST_PED_CP_IT.CD_PED   
		INNER JOIN EST_PED_CP_ORC ON   
		EST_PED_CP.CD_EMP = EST_PED_CP_ORC.CD_EMP AND   
		EST_PED_CP.CD_FILIAL = EST_PED_CP_ORC.CD_FILIAL AND   
		EST_PED_CP.CD_PED = EST_PED_CP_ORC.CD_PED    
	WHERE       
		EST_PED_CP.CD_EMP = @CD_EMP   
		AND EST_PED_CP.CD_FILIAL = @CD_FILIAL   
		AND EST_PED_CP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PED_CP_IT.CD_PROD = @CD_PROD  
	
	--Estorno -- nota fiscal excluida
	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		2 TP_MOV,
		I.DT_CAD,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		'ESTORNO - ' + O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		2	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND CONVERT(DATE,I.DT_CAD)  BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 0  
	order by 
		I.CD_CTR 

end  
--xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  
IF @TP_EST = 2 --Estoque em terceiros  
begin  
	INSERT INTO #RS_MOV  
	SELECT   
		V_EST_NF_ENT.CD_NF,
		2 TP_MOV,  
		CONVERT(CHAR(10),V_EST_NF_ENT.DT_ENT,120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.HR_ENT,''),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = 'RETORNO MERC. DEPOSITO REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10),CD_ORIG)  + ' CIDADE: ' + DS_CID + ' - ' + UF,    
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,  
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		2,  
		2,
		0,
		1 AS TP_DOC,
		CONVERT(CHAR(10),COALESCE(V_EST_NF_ENT.DT_HR_CAD,V_EST_NF_ENT.DT_ENT),120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.DT_HR_CAD,''),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_ENT  
	WHERE     
		CD_EMP = @CD_EMP   
		AND CD_FILIAL = @CD_FILIAL  
		AND DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND CD_PROD = @CD_PROD  
		AND ATU_EST = 1  
		AND TP_ESTQ = 0  
		AND STS_NF = 0  
		AND FLAG_RETORNO_OPERADOR_LOG =1  
		AND NOT EXISTS (SELECT   
						CD_NF  
					   FROM           
						PDV_VD_EST_NF_ENT  
					   WHERE       
						PDV_VD_EST_NF_ENT.CD_EMP = V_EST_NF_ENT.CD_EMP AND  
						PDV_VD_EST_NF_ENT.CD_FILIAL = V_EST_NF_ENT.CD_FILIAL AND  
						PDV_VD_EST_NF_ENT.CD_NF = V_EST_NF_ENT.CD_NF) ;


	--Entrada estorno
	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		1 TP_MOV,
		I.DT_ENT,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		1	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 2  
	order by 
		I.CD_CTR;

			  
	INSERT INTO #RS_MOV  
	SELECT  
		V_EST_NF_SAI.CD_NF,
		2 TP_MOV,      
		CONVERT(CHAR(10),V_EST_NF_SAI.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,V_EST_NF_SAI.HR_EMI_NF),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = 'ENVIO MERC. DEPOSITO REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) + ' CIDADE: ' + DS_CID + ' - ' + UF,  
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0,
		5 AS TP_DOC,
		CONVERT(CHAR(10),COALESCE(V_EST_NF_SAI.DT_HR_CAD,V_EST_NF_SAI.DT_EMI_NF),120) + ' ' + convert(char(8),CONVERT(time,ISNULL(V_EST_NF_SAI.DT_HR_CAD,'')),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_SAI  
	WHERE     
		DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND CD_EMP = @CD_EMP   
		AND CD_FILIAL = @CD_FILIAL  
		AND CD_PROD = @CD_PROD  
		AND BX_EST = 1  
		AND TP_ESTQ = 0 
		AND STS_NF = 0  
		AND ENVIO_OPERADOR_LOG =1   
		--Ajuste de estoque  

	INSERT INTO #RS_MOV
       SELECT
              EST_PROD_IMP.CD_IMP
            , 2 TP_MOV
            , EST_PROD_IMP.DT_CAD
            , CD_MOV = CASE
                           WHEN TP_IMP = 0 THEN 10000
                           WHEN TP_IMP = 1 THEN 10001
                           WHEN TP_IMP = 2 THEN 10002
                           ELSE 10003
                       END
            , DS_MOV_CPL = CASE
                               WHEN TP_IMP = 0 THEN 'AJUSTE DE ESTOQUE'
                               WHEN TP_IMP = 1 THEN 'FECHAMENTO DE BALANCO'
                               ELSE 'SEM CLASSIFICACAO'
                           END
            , DS_OP = CASE
                          WHEN TP_IMP = 0
                               AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL
                               AND EST_PROD_IMP_DETERIORADO.CD_IMP IS NULL THEN CASE
                                                                                    WHEN l.ORIGEM IS NULL THEN CASE
                                                                                                                   WHEN ls.ORIGEM IS NULL THEN CASE
                                                                                                                                                   WHEN le.NR_NF IS NULL THEN 'AJUSTE DE ESTOQUE EFETUADO PELO USUARIO: '+GLB_USU.NM_USU
                                                                                                                                                   ELSE 'ENTRADA OPERADOR LOGISTICO NOTA FISCAL DE ENTRADA NR.: '+CONVERT(VARCHAR(10), le.NR_NF)
                                                                                                                                               END
                                                                                                                   ELSE CASE
                                                                                                                            WHEN ls.ORIGEM = 0 THEN 'SAIDA OPERADOR LOGISTICO PARA A NOTA FISCAL NR.: '+CONVERT(VARCHAR(10), ls.NF_NF)
                                                                                                                            ELSE 'SAIDA OPERADOR LOGISTICO PARA A PRE-FATURA NR.: '+CONVERT(VARCHAR(10), ls.NF_NF)
                                                                                                                        END
                                                                                                               END
                                                                                    ELSE CASE
                                                                                             WHEN l.ORIGEM = 0 THEN 'SAIDA OPERADOR LOGISTICO PARA A NOTA FISCAL NR.: '+CONVERT(VARCHAR(10), l.NF_NF)
                                                                                             ELSE 'SAIDA OPERADOR LOGISTICO PARA A PRE-FATURA NR.: '+CONVERT(VARCHAR(10), l.NF_NF)
                                                                                         END
                                                                                END
                          WHEN TP_IMP = 0
                               AND EST_PROD_IMP_FLUTUANTE.CD_IMP > 0 THEN 'TRANSFERENCIA PARA ESTOQUE FLUTUANTE EFETUADO PELO USUARIO: '+GLB_USU.NM_USU
                          WHEN TP_IMP = 0
                               AND EST_PROD_IMP_DETERIORADO.CD_IMP > 0 THEN 'INFORMACAO DE VENCIDO/DETERIORADOS EFETUADO PELO USUARIO: '+GLB_USU.NM_USU
                          WHEN TP_IMP = 1
                               AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN 'FECHAMENTO DE BALANCO EFETUADO PELO USUARIO: '+GLB_USU.NM_USU
                          WHEN TP_IMP = 2
                               AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN 'DIFERENCA(S) DETECTADA(S) PELO USUARIO: '+GLB_USU.NM_USU
                          WHEN TP_IMP = 3
                               AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN 'AJUSTE DE FALTA(S) DETECTADA(S) ANTERIORMENTE'
                          ELSE 'SEM CLASSIFICACAO, SOLICITE A CLASSIFICACAO DA MESMA'
                      END
            , EST_PROD_IMP.CD_PROD
            , @DS_PROD DS_PROD
            , EST_PROD_IMP.QT_IMP
            , 0 VLR_ENT
            , @VLR_CUSTO
            , 0
            , 1
            , 0
            , 0
            , 3 AS TP_DOC
            , EST_PROD_IMP.DT_CAD_INFO
            , ''
            , 0
            , 0
			,'' NR_DOC
			,'' SR_DOC
       FROM
            EST_PROD_IMP 
            INNER JOIN GLB_USU ON EST_PROD_IMP.CD_USU = GLB_USU.CD_USU
            LEFT OUTER JOIN EST_PROD_IMP_FLUTUANTE ON EST_PROD_IMP.CD_EMP = EST_PROD_IMP_FLUTUANTE.CD_EMP
                                                      AND EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_FLUTUANTE.CD_FILIAL
                                                      AND EST_PROD_IMP.CD_IMP = EST_PROD_IMP_FLUTUANTE.CD_IMP
                                                      AND EST_PROD_IMP.CD_PROD = EST_PROD_IMP_FLUTUANTE.CD_PROD
            LEFT OUTER JOIN EST_PROD_IMP_DETERIORADO ON EST_PROD_IMP.CD_EMP = EST_PROD_IMP_DETERIORADO.CD_EMP
                                                        AND EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_DETERIORADO.CD_FILIAL
                                                        AND EST_PROD_IMP.CD_IMP = EST_PROD_IMP_DETERIORADO.CD_IMP
                                                        AND EST_PROD_IMP.CD_PROD = EST_PROD_IMP_DETERIORADO.CD_PROD
            LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_ENTRADA_ORIGEM l ON EST_PROD_IMP.CD_EMP = l.CD_EMP
                                                                         AND EST_PROD_IMP.CD_FILIAL = l.CD_FILIAL
                                                                         AND EST_PROD_IMP.CD_IMP = l.CD_IMP
                                                                         AND EST_PROD_IMP.CD_PROD = l.CD_PROD
            LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_SAIDA_ORIGEM ls ON EST_PROD_IMP.CD_EMP = ls.CD_EMP
                                                                        AND EST_PROD_IMP.CD_FILIAL = ls.CD_FILIAL
                                                                        AND EST_PROD_IMP.CD_IMP = ls.CD_IMP
                                                                        AND EST_PROD_IMP.CD_PROD = ls.CD_PROD
            LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_SAIDA_NOTA_DESTINO le ON EST_PROD_IMP.CD_EMP = le.CD_EMP
                                                                              AND EST_PROD_IMP.CD_FILIAL = le.CD_FILIAL
                                                                              AND EST_PROD_IMP.CD_IMP = le.CD_IMP
                                                                              AND EST_PROD_IMP.CD_PROD = le.CD_PROD
       WHERE EST_PROD_IMP.CD_EMP = @CD_EMP
             AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL
             AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM
             AND EST_PROD_IMP.CD_PROD = @CD_PROD
             AND EST_PROD_IMP.TP_EST = 2
             AND TP_IMP < 5;

	--Estorno nota fiscal excluida
  	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		2 TP_MOV,
		I.DT_CAD,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		'ESTORNO -' + O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		2	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_CAD  BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 2
	order by 
		I.CD_CTR 

end  
  
--xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  
IF @TP_EST = 3 --Estoque de terceiros  
begin  
	INSERT INTO #RS_MOV  
	SELECT   
		V_EST_NF_ENT.CD_NF,
		2 TP_MOV,  
		CONVERT(CHAR(10),V_EST_NF_ENT.DT_ENT,120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.HR_ENT,''),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = 'ENTRADA DE MERC. DEPOSITO REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10),CD_ORIG)  + ' CIDADE: ' + DS_CID + ' - ' + UF,    
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,  
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0 ,
		1 AS TP_DOC,
		CONVERT(CHAR(10),COALESCE(V_EST_NF_ENT.DT_HR_CAD,V_EST_NF_ENT.DT_ENT),120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.DT_HR_CAD,''),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_ENT  
	WHERE     
		CD_EMP = @CD_EMP   
		AND CD_FILIAL = @CD_FILIAL  
		AND DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND CD_PROD = @CD_PROD  
		AND ATU_EST = 1  
		AND TP_ESTQ = 3  
		AND STS_NF = 0  
		AND FLAG_ENTRADA_OPERADOR_LOG =1  
		AND NOT EXISTS (SELECT   
							CD_NF  
						FROM           
							PDV_VD_EST_NF_ENT  
						WHERE       
							PDV_VD_EST_NF_ENT.CD_EMP = V_EST_NF_ENT.CD_EMP AND  
							PDV_VD_EST_NF_ENT.CD_FILIAL = V_EST_NF_ENT.CD_FILIAL AND  
							PDV_VD_EST_NF_ENT.CD_NF = V_EST_NF_ENT.CD_NF)  
  

	--Entrada estorno
	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		1 TP_MOV,
		I.DT_ENT,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		1	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 3
	order by 
		I.CD_CTR;


	INSERT INTO #RS_MOV  
	SELECT  
		V_EST_NF_SAI.CD_NF,
		2 TP_MOV,      
		CONVERT(CHAR(10),V_EST_NF_SAI.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,V_EST_NF_SAI.HR_EMI_NF),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = 'RETORNO MERC. DEPOSITADA REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) + ' CIDADE: ' + DS_CID + ' - ' + UF,  
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		2,  
		2,
		0,
		5 AS TP_DOC,
		CONVERT(CHAR(10),V_EST_NF_SAI.DT_HR_CAD,120) + ' ' + convert(char(8),CONVERT(time,ISNULL(V_EST_NF_SAI.DT_HR_CAD,'')),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_SAI  
	WHERE     
		DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND CD_EMP = @CD_EMP   
		AND CD_FILIAL = @CD_FILIAL  
		AND CD_PROD = @CD_PROD  
		AND BX_EST = 1  
		AND TP_ESTQ = 3  
		AND STS_NF = 0  
		AND FLAG_RETORNO_OPERADOR_LOG =1   


--Ajuste de estoque  
	 INSERT INTO #RS_MOV  
	 SELECT       
		EST_PROD_IMP.CD_IMP,
		2 TP_MOV, 
		EST_PROD_IMP.DT_CAD,   
		CD_MOV = CASE WHEN TP_IMP = 0 THEN  
						10000  
					WHEN TP_IMP = 1 THEN  
						10001  
					WHEN TP_IMP = 2 THEN  
						10002  
					ELSE  
						10003  
					END,  
		DS_MOV_CPL = CASE WHEN TP_IMP = 0 THEN  
							'AJUSTE DE ESTOQUE'  
						WHEN TP_IMP = 1 THEN  
							'FECHAMENTO DE BALANCO'  
						ELSE  
							'SEM CLASSIFICACAO'  
						END,  
		DS_OP = CASE WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL  AND  EST_PROD_IMP_DETERIORADO.CD_IMP IS NULL THEN  
			CASE WHEN l.ORIGEM IS NULL THEN	
				CASE WHEN ls.ORIGEM IS NULL THEN
					CASE WHEN le.NR_NF IS NULL THEN	
						'AJUSTE DE ESTOQUE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU	
					ELSE
						'ENTRADA OPERADOR LOGISTICO NOTA FISCAL DE ENTRADA NR.: ' + convert(varchar(10),le.NR_NF)
					END
				ELSE
					CASE WHEN ls.ORIGEM = 0 THEN
						'SAIDA OPERADOR LOGISTICO PARA A NOTA FISCAL NR.: ' + convert(varchar(10),ls.NF_NF)
					ELSE
						'SAIDA OPERADOR LOGISTICO PARA A PRE-FATURA NR.: ' + convert(varchar(10),ls.NF_NF)
					END
				END
			ELSE
				CASE WHEN l.ORIGEM = 0 THEN
					'ENTRADA OPERADOR LOGISTICO PARA A NOTA FISCAL NR.: ' + convert(varchar(10),l.NF_NF)
				ELSE
					'ENTRADA OPERADOR LOGISTICO PARA A PRE-FATURA NR.: ' + convert(varchar(10),l.NF_NF)
				END
			END
		WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP > 0 THEN  
			'TRANSFERENCIA PARA ESTOQUE FLUTUANTE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
		WHEN TP_IMP = 0  AND EST_PROD_IMP_DETERIORADO.CD_IMP > 0 THEN  
			'INFORMACAO DE VENCIDO/DETERIORADOS EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
		WHEN TP_IMP = 1 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
			'FECHAMENTO DE BALANCO EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
		WHEN TP_IMP = 2 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
			'DIFERENCA(S) DETECTADA(S) PELO USUARIO: ' + GLB_USU.NM_USU  
		WHEN TP_IMP = 3 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
			'AJUSTE DE FALTA(S) DETECTADA(S) ANTERIORMENTE'   
		ELSE  
			'SEM CLASSIFICACAO, SOLICITE A CLASSIFICACAO DA MESMA'  
		END,  
		EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PROD_IMP.QT_IMP, 
		0 VLR_ENT,  
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM   
		EST_PROD_IMP 
		INNER JOIN GLB_USU ON   
		EST_PROD_IMP.CD_USU = GLB_USU.CD_USU  
		LEFT OUTER JOIN EST_PROD_IMP_FLUTUANTE ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_IMP_FLUTUANTE.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_FLUTUANTE.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_IMP_FLUTUANTE.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_IMP_FLUTUANTE.CD_PROD  
		LEFT OUTER JOIN EST_PROD_IMP_DETERIORADO ON  
		EST_PROD_IMP.CD_EMP = EST_PROD_IMP_DETERIORADO.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL = EST_PROD_IMP_DETERIORADO.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_IMP_DETERIORADO.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_IMP_DETERIORADO.CD_PROD  

		LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_ENTRADA_ORIGEM l ON
		EST_PROD_IMP.CD_EMP = l.CD_EMP AND
		EST_PROD_IMP.CD_FILIAL = l.CD_FILIAL AND
		EST_PROD_IMP.CD_IMP = l.CD_IMP AND
		EST_PROD_IMP.CD_PROD = l.CD_PROD

		LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_SAIDA_ORIGEM ls ON
		EST_PROD_IMP.CD_EMP = ls.CD_EMP AND
		EST_PROD_IMP.CD_FILIAL = ls.CD_FILIAL AND
		EST_PROD_IMP.CD_IMP = ls.CD_IMP AND
		EST_PROD_IMP.CD_PROD = ls.CD_PROD

		LEFT OUTER JOIN V_EST_PROD_IMP_LOGISTICA_ENTRADA_NOTA_DESTINO le ON
		EST_PROD_IMP.CD_EMP = le.CD_EMP AND
		EST_PROD_IMP.CD_FILIAL = le.CD_FILIAL_ENT AND
		EST_PROD_IMP.CD_IMP = le.CD_IMP AND
		EST_PROD_IMP.CD_PROD = le.CD_PROD

	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP   
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL   
		AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 3  
		AND TP_IMP < 5;

	--Estorno nota fiscal excluida
  	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		2 TP_MOV,
		I.DT_CAD,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		'ESTORNO -' + O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		2	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_CAD  BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 3
	order by 
		I.CD_CTR 
end   

IF @TP_EST = 1 --Estoque flutuante
begin  
 
	 
	INSERT INTO #RS_MOV  
	SELECT    
		V_EST_NF_ENT.CD_NF,
		2 TP_MOV, 
		CONVERT(CHAR(10),V_EST_NF_ENT.DT_ENT,120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.HR_ENT,''),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NR_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_ORIG)  + ' CIDADE: ' + DS_CID + ' - ' + UF,  
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,  
		V_EST_NF_ENT.VLR_IT,
		@VLR_CUSTO,  
		0,  
		1,  
		2,
		0,
		1 as TP_DOC,
		CONVERT(CHAR(10),COALESCE(V_EST_NF_ENT.DT_HR_CAD,V_EST_NF_ENT.DT_ENT),120) + ' ' + CONVERT(CHAR(8),ISNULL(V_EST_NF_ENT.DT_HR_CAD,''),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_ENT  
	WHERE     
		CD_EMP = @CD_EMP   
		AND CD_FILIAL = @CD_FILIAL  
		AND DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND CD_PROD = @CD_PROD  
		AND ATU_EST = 1  
		AND TP_ESTQ = 1  
		AND STS_NF = 0  
		AND NOT EXISTS (SELECT  CD_NF  
						FROM PDV_VD_EST_NF_ENT  
						WHERE       
							PDV_VD_EST_NF_ENT.CD_EMP = V_EST_NF_ENT.CD_EMP AND  
							PDV_VD_EST_NF_ENT.CD_FILIAL = V_EST_NF_ENT.CD_FILIAL AND  
							PDV_VD_EST_NF_ENT.CD_NF = V_EST_NF_ENT.CD_NF)  

	--Entrada estorno
	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		1 TP_MOV,
		I.DT_ENT,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		1	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC

	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 1
	order by 
		I.CD_CTR;

  
	INSERT INTO #RS_MOV
	SELECT     
		V_EST_NF_SAI.CD_NF,
		2 TP_MOV, 
		CONVERT(CHAR(10),V_EST_NF_SAI.DT_EMI_NF,120) + ' ' + convert(char(8),CONVERT(time,V_EST_NF_SAI.HR_EMI_NF),114),   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NF_NF) + '  CD. DEST.: ' + CONVERT(VARCHAR(10),CD_CLI) + ' CIDADE: ' + DS_CID + ' - ' + UF,  
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,  
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		2,  
		2,
		0,
		5 AS TP_DOC,
		CONVERT(CHAR(10),COALESCE(V_EST_NF_SAI.DT_HR_CAD,V_EST_NF_SAI.DT_EMI_NF),120) + ' ' + convert(char(8),CONVERT(time,ISNULL(V_EST_NF_SAI.DT_HR_CAD,'')),114),
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_SAI  
	WHERE     
		DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
		AND CD_EMP		= @CD_EMP   
		AND CD_FILIAL	= @CD_FILIAL  
		AND CD_PROD		= @CD_PROD  
		AND BX_EST		= 1  
		AND TP_ESTQ		= 1  
	 --	AND STS_NF		= 0; 

  --Vendas por nota fiscal cancelamento fora do prazo
	INSERT INTO #RS_MOV  
	SELECT   
		V_EST_NF_SAI.CD_NF,
		1 TP_MOV,     
		c.DT_CANCEL,   
		CD_MOV = CD_MOV_OP,  
		DS_MOV_CPL = DS_MOV_OP,  
		DS_OP = 'CANCELAMENTO ' + CASE WHEN C.CANCEL_FORA_PRAZO =1 THEN ' FORA PRAZO' ELSE '' END   +  ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10),NF_NF) + ' USUARIO.: ' + GLB_USU.NM_USU,  
		CD_PROD,   
		@DS_PROD DS_PROD,   
		QT_IT,   
		0 VLR_ENT,
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		5 AS TP_DOC,
		c.DT_CANCEL,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		V_EST_NF_SAI 
		INNER JOIN EST_NF_SAI_CANCEL c ON
		V_EST_NF_SAI.CD_EMP		= c.CD_EMP AND
		V_EST_NF_SAI.CD_FILIAL	= c.CD_FILIAL AND
		V_EST_NF_SAI.CD_NF		= c.CD_NF 
		INNER JOIN GLB_USU ON
		c.CD_USU = GLB_USU.CD_USU
	WHERE     
		c.DT_CANCEL BETWEEN @DT_INI AND @DT_FIM  
		AND V_EST_NF_SAI.CD_EMP = @CD_EMP   
		AND V_EST_NF_SAI.CD_FILIAL = @CD_FILIAL  
		AND V_EST_NF_SAI.CD_PROD = @CD_PROD  
		AND V_EST_NF_SAI.BX_EST = 1  
		AND V_EST_NF_SAI.TP_ESTQ = 1  
		--AND V_EST_NF_SAI.STS_NF = 0  
		--AND EST_NF_SAI_CANCEL.CANCEL_FORA_PRAZO=1
		AND NOT EXISTS (SELECT   
							CD_NF   
						FROM   
							PDV_VD_EST_NF_SAI  
						WHERE  
							V_EST_NF_SAI.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND  
							V_EST_NF_SAI.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND  
							V_EST_NF_SAI.CD_NF = PDV_VD_EST_NF_SAI.CD_NF AND  
							V_EST_NF_SAI.CD_EMP = @CD_EMP  
							AND V_EST_NF_SAI.CD_FILIAL = @CD_FILIAL)  
  ORDER BY
	V_EST_NF_SAI.NF_NF

--Ajuste de estoque  
	INSERT INTO #RS_MOV  
	SELECT   
		EST_PROD_IMP.CD_IMP,
		2 TP_MOV,     
		EST_PROD_IMP.DT_CAD,   
		CD_MOV = CASE WHEN TP_IMP = 0 THEN  
		10000  
		WHEN TP_IMP = 1 THEN  
		10001  
		WHEN TP_IMP = 2 THEN  
		10002  
		ELSE  
		10003  
		END,  
		DS_MOV_CPL = CASE WHEN TP_IMP = 0 THEN  
		'AJUSTE DE ESTOQUE'  
		WHEN TP_IMP = 1 THEN  
		'FECHAMENTO DE BALANCO'  
		ELSE  
		'SEM CLASSIFICACAO'  
		END,  
		DS_OP = CASE WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL  AND  EST_PROD_IMP_DETERIORADO.CD_IMP IS NULL THEN  
							'AJUSTE DE ESTOQUE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
						WHEN TP_IMP = 0  AND EST_PROD_IMP_FLUTUANTE.CD_IMP > 0 THEN  
							'TRANSFERENCIA PARA ESTOQUE FLUTUANTE EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
						WHEN TP_IMP = 0  AND EST_PROD_IMP_DETERIORADO.CD_IMP > 0 THEN  
							'INFORMACAO DE VENCIDO/DETERIORADOS EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
						WHEN TP_IMP = 1 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
							'FECHAMENTO DE BALANCO EFETUADO PELO USUARIO: ' + GLB_USU.NM_USU  
						WHEN TP_IMP = 2 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
							'DIFERENCA(S) DETECTADA(S) PELO USUARIO: ' + GLB_USU.NM_USU  
						WHEN TP_IMP = 3 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
							'AJUSTE DE FALTA(S) DETECTADA(S) ANTERIORMENTE'   
						WHEN TP_IMP = 4 AND EST_PROD_IMP_FLUTUANTE.CD_IMP IS NULL THEN  
							'BLOQUEIO/DESBLOQUEIO PELO USUARIO: '  + GLB_USU.NM_USU  
						ELSE  
							'SEM CLASSIFICACAO, SOLICITE A CLASSIFICACAO DA MESMA'  
						END,  
		EST_PROD_IMP.CD_PROD,   
		@DS_PROD DS_PROD,   
		EST_PROD_IMP.QT_IMP,  
		0 VLR_ENT, 
		@VLR_CUSTO,  
		0,  
		1,  
		0,
		0,
		3 AS TP_DOC,
		EST_PROD_IMP.DT_CAD_INFO,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM   
		EST_PROD_IMP  
		INNER JOIN GLB_USU ON   
		EST_PROD_IMP.CD_USU		= GLB_USU.CD_USU  
		LEFT OUTER JOIN EST_PROD_IMP_FLUTUANTE ON   
		EST_PROD_IMP.CD_EMP		= EST_PROD_IMP_FLUTUANTE.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL	= EST_PROD_IMP_FLUTUANTE.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP		= EST_PROD_IMP_FLUTUANTE.CD_IMP AND   
		EST_PROD_IMP.CD_PROD	= EST_PROD_IMP_FLUTUANTE.CD_PROD  
		LEFT OUTER JOIN EST_PROD_IMP_DETERIORADO ON  
		EST_PROD_IMP.CD_EMP		= EST_PROD_IMP_DETERIORADO.CD_EMP AND      
		EST_PROD_IMP.CD_FILIAL	= EST_PROD_IMP_DETERIORADO.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP		= EST_PROD_IMP_DETERIORADO.CD_IMP AND   
		EST_PROD_IMP.CD_PROD	= EST_PROD_IMP_DETERIORADO.CD_PROD  
		LEFT OUTER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP ON   
		EST_PROD_IMP.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_EMP AND   
		EST_PROD_IMP.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_FILIAL AND   
		EST_PROD_IMP.CD_IMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_IMP AND   
		EST_PROD_IMP.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD  		
	WHERE       
		EST_PROD_IMP.CD_EMP = @CD_EMP   
		AND EST_PROD_IMP.CD_FILIAL = @CD_FILIAL   
		AND EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM  
		AND EST_PROD_IMP.CD_PROD = @CD_PROD  
		AND EST_PROD_IMP.TP_EST = 1  
		AND EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD IS NULL
		AND TP_IMP < 5  

	--Estorno nota fiscal excluida
  	INSERT INTO #RS_MOV  
	SELECT    
		i.CD_CTR ,
		2 TP_MOV,
		I.DT_CAD,   
		I.CD_MOV_OP,  
		O.DS_MOV_OP,  
		'ESTORNO -' + O.DS_MOV_OP + ' REF. NOTA FISCAL NR.: ' + CONVERT(VARCHAR(10), i.NR_NF) + '   CD. ORIGEM.: ' + CONVERT(VARCHAR(10), i.CD_FORN),    
		I.CD_PROD,   
		@DS_PROD DS_PROD,   
		I.QT_IT,  
		I.VLR_IT,
		@VLR_CUSTO,  
		0	VLR_CUSTO_TOTAL,  
		2	TP_TRANSA,  
		0	QT_EST,
		0	TP_LANC_FECHA_EST,
		2 AS TP_DOC,
		I.DT_CAD,
		'',
		0,
		0
		,'' NR_DOC
		,'' SR_DOC
	FROM      
		EST_NF_ENT_IT_ESTORNO I
		INNER JOIN GLB_MOV_OP O ON 
		I.CD_MOV_OP = O.CD_MOV_OP
	WHERE     
		I.CD_EMP = @CD_EMP   
		AND I.CD_FILIAL = @CD_FILIAL  
		AND I.DT_CAD  BETWEEN @DT_INI AND @DT_FIM  
		AND I.CD_PROD = @CD_PROD  
		AND O.ATU_EST = 1  
		AND O.TP_ESTQ = 1
	order by 
		I.CD_CTR 

end 
 
--xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  


	INSERT INTO #RS_EXTRATO (CD_DOC, TP_MOV, DT_MOV,CD_MOV,DS_MOV_CPL,DS_MOV,CD_PROD,
							DS_PROD,QT_IT,QT_EST,VLR_ENT, VLR_CUSTO, 
							VLR_CUSTO_TOTAL, TP_TRANSA,TP_LANC_FECHA_EST,TP_DOC,DT_REGISTRO,
							SNGPC_TEM,SNGPC_LANCADO)  
	SELECT 
		CD_DOC, TP_MOV,DT_MOV,CD_MOV,DS_MOV_CPL,DS_MOV,CD_PROD,
		DS_PROD,QT_IT,0,VLR_ENT,VLR_CUSTO,
		VLR_CUSTO_TOTAL,TP_TRANSA,TP_LANC_FECHA_EST,TP_DOC,DT_REGISTRO,SNGPC_TEM,SNGPC_LANCADO
	FROM 
		#RS_MOV 
	ORDER BY 
		DT_REGISTRO,
		DT_MOV, 
		ORD_APRES, ----AQUI
		TP_TRANSA  
	 
--------------------------------------------------------------------------------------------------


	SET @QT_EST = 0  
	SET @VLR_CUSTO = 0

	DECLARE CalcEstoqueExtrato CURSOR FAST_FORWARD FOR 
	SELECT 
		ISNULL(DT_MOV,@DT_FECHA_EST),
			ORDEM, 
			TP_TRANSA, 
			QT_IT,
			CASE WHEN @TP_EST=1 THEN 20 ELSE 0 END   TP_CUSTO 
	FROM 
		#RS_EXTRATO
	ORDER BY 
		ORDEM
				
	OPEN CalcEstoqueExtrato
	
	FETCH NEXT FROM CalcEstoqueExtrato INTO @DT_MOV,@ORDEM, @TRANSA, @QT_MOV,@TP_CUSTO
	WHILE @@FETCH_STATUS=0
		Begin
		 
			UPDATE 
				#RS_EXTRATO 
			SET @QT_EST = CASE WHEN @TRANSA IN (0,1) THEN  
								ISNULL((@QT_EST + @QT_MOV),0)  
							WHEN TP_TRANSA = 2 THEN  
								ISNULL((@QT_EST - @QT_MOV),0)
							END,  
				@VLR_CUSTO  = ISNULL(dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (@CD_EMP,@CD_FILIAL,@CD_PROD, @DT_MOV,@TP_CUSTO),0),
				QT_EST = ISNULL(@QT_EST,0),  
				VLR_CUSTO= @VLR_CUSTO,
				VLR_CUSTO_TOTAL = ISNULL((@VLR_CUSTO * @QT_EST),0),
				SNGPC_TEM=@CONTROLE_SNGPC
			where
				ORDEM = @ORDEM
			--Proximo registro
			FETCH NEXT FROM CalcEstoqueExtrato INTO @DT_MOV,@ORDEM, @TRANSA, @QT_MOV,@TP_CUSTO
		End

	--Fechando cursos
	CLOSE CalcEstoqueExtrato;
	--Desalocando cursos da memoria
	DEALLOCATE CalcEstoqueExtrato;

--------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------

	UPDATE
		R
	SET 
		TIPO_PREFATURA=V_EST_PED_VD_TIPO_PRE_FATURAS.DS_TIPO
	FROM
		#RS_EXTRATO r INNER JOIN EST_NF_SAI_PED_VD np ON
		@CD_EMP = np.CD_EMP AND
		@CD_FILIAL = np.CD_FILIAL AND
		r.CD_DOC = np.CD_NF 
		INNER JOIN EST_PED_VD ON
		np.CD_EMP = EST_PED_VD.CD_EMP AND
		np.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
		np.CD_PED = EST_PED_VD.CD_PED
		INNER JOIN V_EST_PED_VD_TIPO_PRE_FATURAS ON
		EST_PED_VD.TP_PED = V_EST_PED_VD_TIPO_PRE_FATURAS.CD_TIPO  
	WHERE
		R.TP_DOC=5

	UPDATE
		R
	SET 
		TIPO_PREFATURA=V_EST_PED_VD_TIPO_PRE_FATURAS.DS_TIPO
	FROM
		#RS_EXTRATO r INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF np ON
		@CD_EMP = np.CD_EMP AND
		@CD_FILIAL = np.CD_FIL_DEST AND
		r.CD_DOC = np.CD_NF_ENT
		INNER JOIN EST_NF_SAI_PED_VD ON
		np.CD_EMP = EST_NF_SAI_PED_VD.CD_EMP AND
		np.CD_FIL_ORIG = EST_NF_SAI_PED_VD.CD_FILIAL AND
		np.CD_NF_SAI = EST_NF_SAI_PED_VD.CD_NF
		INNER JOIN EST_PED_VD ON
		EST_NF_SAI_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
		EST_NF_SAI_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
		EST_NF_SAI_PED_VD.CD_PED = EST_PED_VD.CD_PED
		INNER JOIN V_EST_PED_VD_TIPO_PRE_FATURAS ON
		EST_PED_VD.TP_PED = V_EST_PED_VD_TIPO_PRE_FATURAS.CD_TIPO  
	WHERE
		R.TP_DOC=1

IF @CONTROLE_SNGPC=1
BEGIN
	UPDATE
		r
	SET 
		r.SNGPC_LANCADO=1
	FROM
		#RS_EXTRATO r INNER JOIN EST_SNGPC_ENTRADA sngpc ON
		@CD_EMP = sngpc.CD_EMP AND
		@CD_FILIAL = sngpc.CD_FILIAL AND
		r.CD_DOC = sngpc.CD_NF
	WHERE
		R.TP_DOC=1

	UPDATE
		r
	SET 
		r.SNGPC_LANCADO=1
	FROM
		#RS_EXTRATO r INNER JOIN PDV_VD_IT_EST_SNGPC_SAIDA sngpc ON
		@CD_EMP = sngpc.CD_EMP AND
		@CD_FILIAL = sngpc.CD_FILIAL AND
		r.CD_DOC = sngpc.CD_VD
	WHERE
		R.TP_DOC=4
END
	SELECT 
		ORDEM,
		DT_MOV,
		CD_MOV,
		DS_MOV_CPL, 
		DS_MOV, 
		CD_PROD, 
		DS_PROD, 
		ISNULL(QT_IT,0) QT_IT, 
		ISNULL(QT_EST,0) QT_EST,
		ISNULL(VLR_ENT,0) VLR_ENT,
		ISNULL(VLR_CUSTO,0) VLR_CUSTO, 
		ISNULL(VLR_CUSTO_TOTAL,0) VLR_CUSTO_TOTAL,
		TP_TRANSA,
		CD_DOC,
		TP_DOC,
		DT_REGISTRO,
		ISNULL(TIPO_PREFATURA,'') as TIPO_PREFATURA,
		SNGPC_TEM,
		SNGPC_LANCADO
	FROM 
		#RS_EXTRATO 
	ORDER BY
		ORDEM
--------------------------------------------------------------------------------------------------
RETURN  
	DROP TABLE #RS_MOV;
	DROP TABLE #RS_EXTRATO
END
GO 
SP_RECOMPILE P_EST_PROD_CPL_EXTRATO